<?php

namespace App\Console\Commands;

use App\Groups;
use App\Libraries\Parser;
use App\Libraries\Utils;
use App\Posts;
use App\Sources;
use App\Users;
use App\UsersGroups;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Str;

class UpdateSources extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'update-sources';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Update sources';

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        //Update Sources here

        $sources = Sources::all();

        foreach ($sources as $source) {

            $url = $source->url;

            $feed = Parser::xml($url);

            $source->channel_title = isset($feed['channel']['title']) ? $feed['channel']['title'] : '';
            $source->channel_link = isset($feed['channel']['link']) ? $feed['channel']['link'] : '';
            $source->channel_description = isset($feed['channel']['description']) ? $feed['channel']['description'] : '';
            $source->channel_language = isset($feed['channel']['language']) ? $feed['channel']['language'] : '';
            $source->channel_pubDate = isset($feed['channel']['pubDate']) ? $feed['channel']['pubDate'] : '';
            $source->channel_lastBuildDate = isset($feed['channel']['lastBuildDate']) ? $feed['channel']['lastBuildDate'] : '';
            $source->channel_generator = isset($feed['channel']['generator']) ? $feed['channel']['generator'] : '';
            $source->items_count = isset($feed['channel']['item']) ? $source->items_count + sizeof($feed['channel']['item']) : $source->items_count;
            $source->save();

            if (isset($feed['channel']['item']) && $source->auto_update == 1) {
                foreach ($feed['channel']['item'] as $item) {
                    if (!is_null($item['title']) && !is_null($item['description']) && !is_null($item['pubDate']) && !is_null($item['link'])) {
                        $exists_post = Posts::where('slug', Str::slug($item['title']))->first();

                        if (empty($exists_post)) {

                            $find_img = Utils::getImageWithSizeGreaterThan($item['description']);

                            $user_group = Groups::where('name', Users::TYPE_ADMIN)->first();

                            $find_id = UsersGroups::where('group_id', $user_group->id)->pluck('user_id');

                            $first_admin = Users::where('id', $find_id)->first();

                            $post_item = new Posts();
                            $post_item->author_id = $first_admin->id;
                            $post_item->title = isset($item['title']) ? $item['title'] : '';
                            $post_item->slug = isset($item['title']) ? Str::slug($item['title']) : '';
                            $post_item->link = isset($item['link']) ? $item['link'] : '';
                            $post_item->featured = 0;
                            $post_item->category_id = $source->category_id;
                            $post_item->render_type = strlen($find_img) > 0 ? Posts::RENDER_TYPE_IMAGE : Posts::RENDER_TYPE_TEXT;
                            $post_item->type = Posts::TYPE_SOURCE;
                            $post_item->source_id = $source->id;
                            $post_item->rating_box = 0;
                            $post_item->description = isset($item['description']) ? $item['description'] : '';
                            $post_item->featured_image = $find_img;
                            $post_item->created_at = isset($item['pubDate']) ? Carbon::createFromFormat("D, j F Y H:i:s O", $item['pubDate'])->format('Y-m-d H:i:s') : '';
                            $post_item->views = 1;
                            $post_item->save();
                        } else {
                            $exists_post->description = isset($item['description']) ? $item['description'] : '';
                            $exists_post->save();
                        }
                    }
                }
            }
        }

    }
}
